
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_A")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B9")


    # Set objective function
    m.setObjective(4 * x0 + 3 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7 * x0 + 14 * x1 >= 42, "digestive_support_min")
    m.addConstr(16 * x0 + 7 * x1 >= 29, "cardiovascular_support_min")
    m.addConstr(15 * x0 + 6 * x1 >= 69, "immune_support_min")
    m.addConstr(9 * x0 + 17 * x1 >= 43, "kidney_support_min")
    m.addConstr(5 * x0 - 3 * x1 >= 0, "vitamin_ratio")
    m.addConstr(7 * x0 + 14 * x1 <= 132, "digestive_support_max")
    m.addConstr(16 * x0 + 7 * x1 <= 94, "cardiovascular_support_max")
    m.addConstr(15 * x0 + 6 * x1 <= 129, "immune_support_max")
    m.addConstr(9 * x0 + 17 * x1 <= 113, "kidney_support_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_A: %g' % x0.x)
        print('vitamin_B9: %g' % x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
