
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables (allowing for fractional numbers of milligrams)
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_A")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B9")

# Objective function: Maximize 4*x1 + 3*x2
m.setObjective(4*x1 + 3*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(7*x1 + 14*x2 >= 42, "min_digestive_support")
m.addConstr(16*x1 + 7*x2 >= 29, "min_cardiovascular_support")
m.addConstr(15*x1 + 6*x2 >= 69, "min_immune_support")
m.addConstr(9*x1 + 17*x2 >= 43, "min_kidney_support")
m.addConstr(5*x1 - 3*x2 >= 0, "additional_constraint")
m.addConstr(7*x1 + 14*x2 <= 132, "max_digestive_support")
m.addConstr(16*x1 + 7*x2 <= 94, "max_cardiovascular_support")
m.addConstr(15*x1 + 6*x2 <= 129, "max_immune_support")
m.addConstr(9*x1 + 17*x2 <= 113, "max_kidney_support")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin A: {x1.x}")
    print(f"Milligrams of Vitamin B9: {x2.x}")
else:
    print("No optimal solution found")
