
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin A
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B9

    # Define the objective function
    model.setObjective(4 * x0 + 3 * x1, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7 * x0 + 14 * x1 >= 42, name="digestive_support_index_min")
    model.addConstr(16 * x0 + 7 * x1 >= 29, name="cardiovascular_support_index_min")
    model.addConstr(15 * x0 + 6 * x1 >= 69, name="immune_support_index_min")
    model.addConstr(9 * x0 + 17 * x1 >= 43, name="kidney_support_index_min")
    model.addConstr(5 * x0 - 3 * x1 >= 0, name="vitamin_constraint")
    model.addConstr(7 * x0 + 14 * x1 <= 132, name="digestive_support_index_max")
    model.addConstr(16 * x0 + 7 * x1 <= 94, name="cardiovascular_support_index_max")
    model.addConstr(15 * x0 + 6 * x1 <= 129, name="immune_support_index_max")
    model.addConstr(9 * x0 + 17 * x1 <= 113, name="kidney_support_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin A: {x0.varValue}")
        print(f"Milligrams of vitamin B9: {x1.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
