
import gurobipy as gp

# Create a new model
model = gp.Model("resource_allocation")

# Create variables
intrusion_analysts = model.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")
bandwidth = model.addVar(vtype=gp.GRB.INTEGER, name="bandwidth")


# Set objective function
model.setObjective(9.77 * intrusion_analysts + 5.87 * bandwidth, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * intrusion_analysts + 9 * bandwidth >= 9, "min_cost")
model.addConstr(1 * intrusion_analysts + 6 * bandwidth >= 55, "min_latency")
model.addConstr(-2 * intrusion_analysts + 6 * bandwidth >= 0, "bandwidth_constraint")
model.addConstr(6 * intrusion_analysts + 9 * bandwidth <= 19, "max_cost")
model.addConstr(1 * intrusion_analysts + 6 * bandwidth <= 76, "max_latency")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Intrusion Analysts: {intrusion_analysts.x}")
    print(f"  Bandwidth: {bandwidth.x}")
    print(f"  Objective Value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

