
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")
x2 = m.addVar(vtype=GRB.INTEGER, name="Mbps_bandwidth_allocated_to_monitoring")

# Set the objective function
m.setObjective(9.77*x1 + 5.87*x2, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(6*x1 + 9*x2 <= 19, "dollar_cost_constraint")
m.addConstr(6*x1 + 9*x2 >= 9, "minimum_dollar_cost")
m.addConstr(x1 + 6*x2 >= 55, "network_latency_lower_bound")
m.addConstr(x1 + 6*x2 <= 76, "network_latency_upper_bound")
m.addConstr(-2*x1 + 6*x2 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Intrusion Analysts: {x1.x}")
    print(f"Mbps Bandwidth Allocated to Monitoring: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
