
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name="intrusion_analysts")
    x2 = model.addVar(vtype=gurobi.GRB.INTEGER, name="Mbps_bandwidth_allocated")

    # Objective function: maximize 9.77*x1 + 5.87*x2
    model.setObjective(9.77*x1 + 5.87*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6*x1 + 9*x2 >= 9, name="min_spend")
    model.addConstr(x1 + 6*x2 >= 55, name="min_latency")
    model.addConstr(-2*x1 + 6*x2 >= 0, name="linear_constraint")
    model.addConstr(6*x1 + 9*x2 <= 19, name="max_spend")
    model.addConstr(x1 + 6*x2 <= 76, name="max_latency")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Intrusion analysts: {x1.varValue}")
        print(f"Mbps bandwidth allocated: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
