
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x0 = model.addVar(name="protein_bars", lb=0)  # No lower bound, but can be fractional
x1 = model.addVar(name="granola_bars", lb=0)  # No lower bound, but can be fractional
x2 = model.addVar(name="black_beans", lb=0)  # No lower bound, but can be fractional
x3 = model.addVar(name="chicken_breasts", lb=0)  # No lower bound, but can be fractional

# Objective function
model.setObjective(8*x0 + 4*x1 + 9*x2 + 2*x3, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(23*x0 + 27*x1 + 4*x2 + 11*x3 <= 543)
model.addConstr(7*x0 + 2*x1 + 5*x2 + 4*x3 <= 246)
model.addConstr(9*x0 + 21*x1 + 28*x2 + 5*x3 <= 597)
model.addConstr(23*x0 + 11*x3 >= 108)
model.addConstr(7*x0 + 5*x2 >= 27)
model.addConstr(5*x2 + 4*x3 >= 34)
model.addConstr(21*x1 + 28*x2 >= 103)
model.addConstr(9*x0 + 5*x3 >= 110)
model.addConstr(9*x0 + 21*x1 + 28*x2 >= 75)
model.addConstr(9*x0 + 28*x2 + 5*x3 >= 75)
model.addConstr(9*x0 + 21*x1 + 28*x2 >= 146)
model.addConstr(9*x0 + 28*x2 + 5*x3 >= 146)
model.addConstr(23*x0 + 11*x3 <= 405)
model.addConstr(4*x2 + 11*x3 <= 171)
model.addConstr(27*x1 + 4*x2 <= 310)
model.addConstr(23*x0 + 27*x1 <= 371)
model.addConstr(23*x0 + 4*x2 <= 378)
model.addConstr(23*x0 + 27*x1 + 4*x2 + 11*x3 <= 378)
model.addConstr(2*x1 + 4*x3 <= 110)
model.addConstr(7*x0 + 4*x3 <= 178)
model.addConstr(7*x0 + 2*x1 + 5*x2 + 4*x3 <= 178)
model.addConstr(21*x1 + 28*x2 <= 514)
model.addConstr(9*x0 + 21*x1 <= 405)
model.addConstr(9*x0 + 21*x1 + 28*x2 + 5*x3 <= 405)

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Protein bars: ", x0.varValue)
    print("Granola bars: ", x1.varValue)
    print("Black beans: ", x2.varValue)
    print("Chicken breasts: ", x3.varValue)
else:
    print("The model is infeasible")
