
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.CONTINUOUS, name="x0") # hours worked by Ringo
    x1 = model.addVar(vtype=GRB.CONTINUOUS, name="x1") # hours worked by George
    x2 = model.addVar(vtype=GRB.INTEGER, name="x2") # hours worked by Jean


    # Set objective function
    model.setObjective(1.52 * x0 + 6.32 * x1 + 9.17 * x2, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * x1 + 35 * x2 >= 56, "c0")
    model.addConstr(5 * x0 + 6 * x1 >= 31, "c1")
    model.addConstr(5 * x0 + 6 * x1 + 35 * x2 >= 31, "c2")
    model.addConstr(13 * x1 + 13 * x2 >= 208, "c3")
    model.addConstr(9 * x0 + 13 * x2 >= 198, "c4")
    model.addConstr(9 * x0 + 13 * x1 + 13 * x2 >= 198, "c5")
    model.addConstr(21 * x0 + 4 * x1 >= 48, "c6")
    model.addConstr(21 * x0 + 4 * x1 + 5 * x2 >= 48, "c7")
    model.addConstr(-5 * x0 + 6 * x2 >= 0, "c8")
    model.addConstr(4 * x0 - 5 * x1 >= 0, "c9")
    model.addConstr(6 * x1 + 35 * x2 <= 186, "c10")
    model.addConstr(5 * x0 + 6 * x1 <= 84, "c11")
    model.addConstr(21 * x0 + 5 * x2 <= 126, "c12")
    model.addConstr(21 * x0 + 4 * x1 <= 202, "c13")
    model.addConstr(21 * x0 + 4 * x1 + 5 * x2 <= 232, "c14")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print('The problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
