
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # hours worked by Ringo
x1 = m.addVar(name="x1", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # hours worked by George
x2 = m.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Jean

# Define the objective function
m.setObjective(1.52*x0 + 6.32*x1 + 9.17*x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x0 <= 244)
m.addConstr(9*x0 <= 659)
m.addConstr(21*x0 <= 331)
m.addConstr(6*x1 <= 244)
m.addConstr(13*x1 <= 659)
m.addConstr(4*x1 <= 331)
m.addConstr(35*x2 <= 244)
m.addConstr(13*x2 <= 659)
m.addConstr(5*x2 <= 331)
m.addConstr(6*x1 + 35*x2 >= 56)
m.addConstr(5*x0 + 6*x1 >= 31)
m.addConstr(5*x0 + 6*x1 + 35*x2 >= 31)
m.addConstr(13*x1 + 13*x2 >= 208)
m.addConstr(9*x0 + 13*x2 >= 198)
m.addConstr(9*x0 + 13*x1 + 13*x2 >= 198)
m.addConstr(21*x0 + 4*x1 >= 48)
m.addConstr(21*x0 + 4*x1 + 5*x2 >= 48)
m.addConstr(-5*x0 + 6*x2 >= 0)
m.addConstr(4*x0 - 5*x1 >= 0)
m.addConstr(6*x1 + 35*x2 <= 186)
m.addConstr(5*x0 + 6*x1 <= 84)
m.addConstr(21*x0 + 5*x2 <= 126)
m.addConstr(21*x0 + 4*x1 <= 202)
m.addConstr(21*x0 + 4*x1 + 5*x2 <= 232)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Ringo: ", x0.varValue)
    print("Hours worked by George: ", x1.varValue)
    print("Hours worked by Jean: ", x2.varValue)
else:
    print("The model is infeasible")
