
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
tomatoes = m.addVar(vtype=GRB.INTEGER, name="tomatoes")
oranges = m.addVar(vtype=GRB.INTEGER, name="oranges")
kale_salads = m.addVar(vtype=GRB.INTEGER, name="kale_salads")
protein_bars = m.addVar(vtype=GRB.CONTINUOUS, name="protein_bars")
bowls_of_pasta = m.addVar(vtype=GRB.INTEGER, name="bowls_of_pasta")


# Set objective function
m.setObjective(2.22*tomatoes**2 + 8.93*tomatoes*oranges + 4.91*tomatoes*protein_bars + 8.67*tomatoes*bowls_of_pasta + 1.29*oranges**2 + 2.02*oranges*protein_bars + 3.36*protein_bars**2 + 4.39*protein_bars*bowls_of_pasta + 9.39*kale_salads + 1.36*protein_bars, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*tomatoes + 8*kale_salads + 14*bowls_of_pasta >= 17)
m.addConstr(14*tomatoes + 5*oranges + 11*protein_bars >= 17)
m.addConstr(5*oranges**2 + 8*kale_salads**2 + 14*bowls_of_pasta**2 >= 17)
m.addConstr(5*oranges + 11*protein_bars + 14*bowls_of_pasta >= 17)
m.addConstr(14*tomatoes**2 + 5*oranges**2 + 14*bowls_of_pasta**2 >= 17)
m.addConstr(5*oranges + 8*kale_salads + 11*protein_bars >= 17)
m.addConstr(14*tomatoes + 8*kale_salads + 14*bowls_of_pasta >= 18)
m.addConstr(14*tomatoes + 5*oranges + 11*protein_bars >= 18)
m.addConstr(5*oranges + 8*kale_salads + 14*bowls_of_pasta >= 18)
m.addConstr(5*oranges + 11*protein_bars + 14*bowls_of_pasta >= 18)
m.addConstr(14*tomatoes + 5*oranges + 14*bowls_of_pasta >= 18)
m.addConstr(5*oranges + 8*kale_salads + 11*protein_bars >= 18)
m.addConstr(14*tomatoes + 8*kale_salads + 14*bowls_of_pasta >= 33)
m.addConstr(14*tomatoes + 5*oranges + 11*protein_bars >= 33)
m.addConstr(5*oranges**2 + 8*kale_salads**2 + 14*bowls_of_pasta**2 >= 33)
m.addConstr(5*oranges**2 + 11*protein_bars**2 + 14*bowls_of_pasta**2 >= 33)
m.addConstr(14*tomatoes + 5*oranges + 14*bowls_of_pasta >= 33)
m.addConstr(5*oranges + 8*kale_salads + 11*protein_bars >= 33)
m.addConstr(14*tomatoes + 8*kale_salads + 14*bowls_of_pasta >= 31)
m.addConstr(14*tomatoes**2 + 5*oranges**2 + 11*protein_bars**2 >= 31)
m.addConstr(5*oranges**2 + 8*kale_salads**2 + 14*bowls_of_pasta**2 >= 31)
m.addConstr(5*oranges + 11*protein_bars + 14*bowls_of_pasta >= 31)
m.addConstr(14*tomatoes**2 + 5*oranges**2 + 14*bowls_of_pasta**2 >= 31)
m.addConstr(5*oranges**2 + 8*kale_salads**2 + 11*protein_bars**2 >= 31)
m.addConstr(14*tomatoes**2 + 8*kale_salads**2 + 14*bowls_of_pasta**2 >= 26)
m.addConstr(14*tomatoes + 5*oranges + 11*protein_bars >= 26)
m.addConstr(5*oranges**2 + 8*kale_salads**2 + 14*bowls_of_pasta**2 >= 26)
m.addConstr(5*oranges + 11*protein_bars + 14*bowls_of_pasta >= 26)
m.addConstr(14*tomatoes**2 + 5*oranges**2 + 14*bowls_of_pasta**2 >= 26)
m.addConstr(5*oranges**2 + 8*kale_salads**2 + 11*protein_bars**2 >= 26)
m.addConstr(14*tomatoes + 8*kale_salads + 14*bowls_of_pasta >= 27)
m.addConstr(14*tomatoes + 5*oranges + 11*protein_bars >= 27)
m.addConstr(5*oranges + 8*kale_salads + 14*bowls_of_pasta >= 27)
m.addConstr(5*oranges**2 + 11*protein_bars**2 + 14*bowls_of_pasta**2 >= 27)
m.addConstr(14*tomatoes + 5*oranges + 14*bowls_of_pasta >= 27)
m.addConstr(5*oranges + 8*kale_salads + 11*protein_bars >= 27)
m.addConstr(5*oranges + 14*bowls_of_pasta <= 163)
m.addConstr(14*tomatoes + 8*kale_salads <= 118)
m.addConstr(5*oranges + 11*protein_bars <= 177)
m.addConstr(8*kale_salads + 14*bowls_of_pasta <= 51)
m.addConstr(14*tomatoes + 5*oranges + 14*bowls_of_pasta <= 97)
m.addConstr(8*kale_salads**2 + 11*protein_bars**2 + 14*bowls_of_pasta**2 <= 147)
m.addConstr(5*oranges + 8*kale_salads + 11*protein_bars <= 62)
m.addConstr(14*tomatoes + 5*oranges + 8*kale_salads + 11*protein_bars + 14*bowls_of_pasta <= 62)
m.addConstr(14*tomatoes + 5*oranges + 8*kale_salads + 11*protein_bars + 14*bowls_of_pasta <= 178)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

