
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B6
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B2
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B1


    # Set objective function
    m.setObjective(4*x0 + 4*x1 + 2*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2*x0 + 2*x1 + 13*x2 <= 115, "c0")
    m.addConstr(15*x0 + 12*x1 + 1*x2 <= 90, "c1")
    m.addConstr(14*x0 + 13*x1 + 11*x2 <= 81, "c2")
    m.addConstr(16*x0 + 5*x1 + 6*x2 <= 85, "c3")
    m.addConstr(15*x0 + 12*x1 >= 23, "c4")
    m.addConstr(15*x0 + 1*x2 >= 27, "c5")
    m.addConstr(14*x0 + 13*x1 >= 12, "c6")
    m.addConstr(5*x1 + 6*x2 >= 11, "c7")
    m.addConstr(16*x0 + 5*x1 + 6*x2 >= 15, "c8")
    m.addConstr(2*x1 + 13*x2 <= 96, "c9")
    m.addConstr(2*x0 + 2*x1 + 13*x2 <= 96, "c10")
    m.addConstr(15*x0 + 1*x2 <= 74, "c11")
    m.addConstr(12*x1 + 1*x2 <= 58, "c12")
    m.addConstr(15*x0 + 12*x1 + 1*x2 <= 58, "c13")
    m.addConstr(14*x0 + 13*x1 <= 77, "c14")
    m.addConstr(14*x0 + 11*x2 <= 75, "c15")
    m.addConstr(13*x1 + 11*x2 <= 79, "c16")
    m.addConstr(14*x0 + 13*x1 + 11*x2 <= 79, "c17")
    m.addConstr(5*x1 + 6*x2 <= 35, "c18")
    m.addConstr(16*x0 + 5*x1 + 6*x2 <= 35, "c19")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
