
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")

    # Objective function
    model.setObjective(4*x0 + 4*x1 + 2*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x0 <= 115)
    model.addConstr(15*x0 <= 90)
    model.addConstr(14*x0 <= 81)
    model.addConstr(16*x0 <= 85)
    model.addConstr(2*x1 <= 115)
    model.addConstr(12*x1 <= 90)
    model.addConstr(13*x1 <= 81)
    model.addConstr(5*x1 <= 85)
    model.addConstr(13*x2 <= 115)
    model.addConstr(x2 <= 90)
    model.addConstr(11*x2 <= 81)
    model.addConstr(6*x2 <= 85)
    model.addConstr(15*x0 + 12*x1 >= 23)
    model.addConstr(15*x0 + x2 >= 27)
    model.addConstr(14*x0 + 13*x1 >= 12)
    model.addConstr(5*x1 + 6*x2 >= 11)
    model.addConstr(16*x0 + 5*x1 + 6*x2 >= 15)
    model.addConstr(2*x1 + 13*x2 <= 96)
    model.addConstr(2*x0 + 2*x1 + 13*x2 <= 96)
    model.addConstr(15*x0 + x2 <= 74)
    model.addConstr(12*x1 + x2 <= 58)
    model.addConstr(15*x0 + 12*x1 + x2 <= 58)
    model.addConstr(14*x0 + 13*x1 <= 77)
    model.addConstr(14*x0 + 11*x2 <= 75)
    model.addConstr(13*x1 + 11*x2 <= 79)
    model.addConstr(14*x0 + 13*x1 + 11*x2 <= 79)
    model.addConstr(5*x1 + 6*x2 <= 35)
    model.addConstr(16*x0 + 5*x1 + 6*x2 <= 35)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
