
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name="black_beans")
x1 = m.addVar(name="corn_cobs")
x2 = m.addVar(name="chicken_thighs")
x3 = m.addVar(name="steaks")

# Set objective function
m.setObjective(5.59*x0 + 4.85*x1 + 2.5*x2 + 5.12*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x0 + x1 + 8*x3 >= 33, name="min_fiber_from_black_corn_steaks")
m.addConstr(8*x0 + x1 <= 78, name="max_fiber_from_black_corn")

# Add other constraints here following the same pattern

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print('No optimal solution found')
