
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
eggs = m.addVar(lb=0, name="eggs")
bananas = m.addVar(lb=0, name="bananas")
protein_bars = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="protein_bars")
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hot_dogs")


# Set objective function
m.setObjective(5*eggs**2 + 3*eggs*protein_bars + 6*bananas**2 + 1*bananas*protein_bars + 6*bananas*hot_dogs + 5*protein_bars**2 + 2*eggs + 2*hot_dogs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20*eggs + 3*bananas + 5*protein_bars + 4*hot_dogs <= 264, "c0")
m.addConstr(15*eggs + 6*bananas + 6*protein_bars + 26*hot_dogs <= 163, "c1")
m.addConstr(12*eggs + 14*bananas + 19*protein_bars + 20*hot_dogs <= 239, "c2")
m.addConstr(3*bananas**2 + 4*hot_dogs**2 >= 55, "c3")
m.addConstr(3*bananas**2 + 5*protein_bars**2 >= 31, "c4")
m.addConstr(20*eggs**2 + 4*hot_dogs**2 >= 48, "c5")
m.addConstr(20*eggs + 3*bananas + 5*protein_bars + 4*hot_dogs >= 48, "c6")
m.addConstr(6*bananas**2 + 26*hot_dogs**2 >= 15, "c7")
m.addConstr(15*eggs + 6*protein_bars >= 17, "c8")
m.addConstr(15*eggs + 6*bananas + 6*protein_bars + 26*hot_dogs >= 17, "c9")
m.addConstr(12*eggs + 20*hot_dogs >= 48, "c10")
m.addConstr(12*eggs + 19*protein_bars >= 46, "c11")
m.addConstr(12*eggs + 14*bananas >= 50, "c12")
m.addConstr(14*bananas + 19*protein_bars >= 54, "c13")
m.addConstr(12*eggs**2 + 14*bananas**2 + 19*protein_bars**2 >= 30, "c14")
m.addConstr(12*eggs + 14*bananas + 20*hot_dogs >= 30, "c15")
m.addConstr(12*eggs + 19*protein_bars + 20*hot_dogs >= 30, "c16")
m.addConstr(14*bananas + 19*protein_bars + 20*hot_dogs >= 30, "c17")
m.addConstr(12*eggs**2 + 14*bananas**2 + 19*protein_bars**2 >= 46, "c18")
m.addConstr(12*eggs**2 + 14*bananas**2 + 20*hot_dogs**2 >= 46, "c19")
m.addConstr(12*eggs + 19*protein_bars + 20*hot_dogs >= 46, "c20")
m.addConstr(14*bananas + 19*protein_bars + 20*hot_dogs >= 46, "c21")
m.addConstr(12*eggs + 14*bananas + 19*protein_bars >= 56, "c22")
m.addConstr(12*eggs**2 + 14*bananas**2 + 20*hot_dogs**2 >= 56, "c23")
m.addConstr(12*eggs + 19*protein_bars + 20*hot_dogs >= 56, "c24")
m.addConstr(14*bananas + 19*protein_bars + 20*hot_dogs >= 56, "c25")
m.addConstr(12*eggs + 14*bananas + 19*protein_bars >= 51, "c26")
m.addConstr(12*eggs + 14*bananas + 20*hot_dogs >= 51, "c27")
m.addConstr(12*eggs + 19*protein_bars + 20*hot_dogs >= 51, "c28")
m.addConstr(14*bananas**2 + 19*protein_bars**2 + 20*hot_dogs**2 >= 51, "c29")
m.addConstr(12*eggs + 14*bananas + 19*protein_bars + 20*hot_dogs >= 51, "c30")
m.addConstr(-6*protein_bars**2 + 7*hot_dogs**2 >= 0, "c31")
m.addConstr(bananas - 2*hot_dogs >= 0, "c32")
m.addConstr(15*eggs**2 + 6*bananas**2 <= 82, "c33")
m.addConstr(6*protein_bars + 26*hot_dogs <= 163, "c34")
m.addConstr(15*eggs + 26*hot_dogs <= 76, "c35")
m.addConstr(6*bananas + 26*hot_dogs <= 163, "c36")
m.addConstr(15*eggs + 6*protein_bars <= 59, "c37")
m.addConstr(12*eggs + 14*bananas <= 76, "c38")
m.addConstr(12*eggs + 19*protein_bars <= 234, "c39")
m.addConstr(12*eggs**2 + 19*protein_bars**2 + 20*hot_dogs**2 <= 164, "c40")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print("  eggs:", eggs.x)
    print("  bananas:", bananas.x)
    print("  protein bars:", protein_bars.x)
    print("  hot dogs:", hot_dogs.x)
    print("Objective value:", m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print("Optimization terminated with status:", m.status)

