
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="eggs")
x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="bananas")
x2 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="protein bars", vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="hot dogs", vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(5*x0**2 + 3*x0*x2 + 6*x1**2 + x1*x2 + 6*x1*x3 + 5*x2**2 + 2*x0 + 2*x3, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(20*x0 + 3*x1 + 5*x2 + 4*x3 <= 264)
model.addConstr(15*x0 + 6*x1 + 6*x2 + 26*x3 <= 163)
model.addConstr(12*x0 + 14*x1 + 19*x2 + 20*x3 <= 239)
model.addConstr(3*x1**2 + 4*x3**2 >= 55)
model.addConstr(3*x1**2 + 5*x2**2 >= 31)
model.addConstr(20*x0**2 + 4*x3**2 >= 48)
model.addConstr(20*x0 + 3*x1 + 5*x2 + 4*x3 >= 48)
model.addConstr(6*x1**2 + 26*x3**2 >= 15)
model.addConstr(15*x0 + 6*x2 >= 17)
model.addConstr(15*x0 + 6*x1 + 6*x2 + 26*x3 >= 17)
model.addConstr(12*x0 + 20*x3 >= 48)
model.addConstr(12*x0 + 19*x2 >= 46)
model.addConstr(12*x0 + 14*x1 >= 50)
model.addConstr(14*x1 + 19*x2 >= 54)
model.addConstr(12*x0**2 + 14*x1**2 + 19*x2**2 >= 30)
model.addConstr(12*x0 + 14*x1 + 20*x3 >= 30)
model.addConstr(12*x0 + 19*x2 + 20*x3 >= 30)
model.addConstr(14*x1 + 19*x2 + 20*x3 >= 30)
model.addConstr(12*x0**2 + 14*x1**2 + 19*x2**2 >= 46)
model.addConstr(12*x0**2 + 14*x1**2 + 20*x3**2 >= 46)
model.addConstr(12*x0 + 19*x2 + 20*x3 >= 46)
model.addConstr(14*x1 + 19*x2 + 20*x3 >= 46)
model.addConstr(12*x0 + 14*x1 + 19*x2 >= 56)
model.addConstr(12*x0**2 + 14*x1**2 + 20*x3**2 >= 56)
model.addConstr(12*x0 + 19*x2 + 20*x3 >= 56)
model.addConstr(14*x1 + 19*x2 + 20*x3 >= 56)
model.addConstr(12*x0 + 14*x1 + 19*x2 >= 51)
model.addConstr(12*x0 + 14*x1 + 20*x3 >= 51)
model.addConstr(12*x0 + 19*x2 + 20*x3 >= 51)
model.addConstr(14*x1**2 + 19*x2**2 + 20*x3**2 >= 51)
model.addConstr(12*x0 + 14*x1 + 19*x2 + 20*x3 >= 51)
model.addConstr(-6*x2**2 + 7*x3**2 >= 0)
model.addConstr(x1 - 2*x3 >= 0)
model.addConstr(225*x0**2 + 36*x1**2 <= 82)
model.addConstr(6*x2 + 26*x3 <= 163)
model.addConstr(15*x0 + 26*x3 <= 76)
model.addConstr(6*x1 + 26*x3 <= 163)
model.addConstr(15*x0 + 6*x2 <= 59)
model.addConstr(12*x0 + 14*x1 <= 76)
model.addConstr(12*x0 + 19*x2 <= 234)
model.addConstr(12*x0**2 + 19*x2**2 + 20*x3**2 <= 164)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Eggs: ", x0.varValue)
    print("Bananas: ", x1.varValue)
    print("Protein Bars: ", x2.varValue)
    print("Hot Dogs: ", x3.varValue)
else:
    print("No solution found")
