
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.CONTINUOUS, name="x0")  # milligrams of vitamin D
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1")  # milligrams of vitamin B7
    x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2")  # grams of carbohydrates


    # Set objective function
    m.setObjective(6.02*x0**2 + 9.35*x0*x2 + 8.77*x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1*x0 + 17*x1 + 6*x2 >= 33, "c0")
    m.addConstr(1*x0 + 6*x2 >= 28, "c1")
    m.addConstr(1*x0 + 17*x1 + 6*x2 >= 26, "c2")
    m.addConstr(4*x0 + 14*x1 + 8*x2 >= 38, "c3")
    m.addConstr(2*x0 - x2 >= 0, "c4")
    m.addConstr(-3*x0**2 + 9*x1**2 >= 0, "c5")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        for v in m.getVars():
            print(f"{v.varName}: {v.x}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
