
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=-float('inf'), ub=float('inf'), name="milligrams of calcium")
    x2 = model.addVar(lb=-float('inf'), ub=float('inf'), name="milligrams of vitamin B6")
    x3 = model.addVar(lb=-float('inf'), ub=float('inf'), type=gurobi.GRB.INTEGER, name="milligrams of magnesium")
    x4 = model.addVar(lb=-float('inf'), ub=float('inf'), type=gurobi.GRB.INTEGER, name="grams of fiber")

    # Define the objective function
    model.setObjective(5.58*x1 + 8.21*x2 + 1.51*x3 + 6.53*x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(18*x1 <= 445)
    model.addConstr(12*x2 <= 445)
    model.addConstr(20*x3 <= 445)
    model.addConstr(26*x4 <= 445)
    model.addConstr(18*x1 + 26*x4 >= 58)
    model.addConstr(18*x1 + 20*x3 <= 246)
    model.addConstr(18*x1 + 12*x2 <= 219)
    model.addConstr(12*x2 + 26*x4 <= 253)
    model.addConstr(18*x1 + 12*x2 + 20*x3 <= 331)
    model.addConstr(12*x2 + 20*x3 + 26*x4 <= 125)
    model.addConstr(18*x1 + 12*x2 + 20*x3 + 26*x4 <= 125)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of calcium: {x1.varValue}")
        print(f"Milligrams of vitamin B6: {x2.varValue}")
        print(f"Milligrams of magnesium: {x3.varValue}")
        print(f"Grams of fiber: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
