
import gurobipy as gp

# Create a new model
model = gp.Model("food_optimization")

# Create variables
bagged_salads = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
knishes = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="knishes")

# Set objective function
model.setObjective(5.3 * bagged_salads + 8.08 * knishes, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(12 * bagged_salads + 17 * knishes >= 29, "iron_min")
model.addConstr(1 * bagged_salads + 22 * knishes >= 14, "tastiness_min")
model.addConstr(8 * bagged_salads - 5 * knishes >= 0, "bagged_salads_knishes_relation")
model.addConstr(12 * bagged_salads + 17 * knishes <= 78, "iron_max")
model.addConstr(1 * bagged_salads + 22 * knishes <= 40, "tastiness_max")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Bagged Salads: {bagged_salads.x}")
    print(f"  Knishes: {knishes.x}")
    print(f"  Objective Value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

