
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagged_salads")
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="knishes")

# Set the objective function
m.setObjective(5.3*x0 + 8.08*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(12*x0 + 17*x1 >= 29, "iron_min")
m.addConstr(12*x0 + 17*x1 <= 78, "iron_max")
m.addConstr(x0 + 22*x1 >= 14, "taste_min")
m.addConstr(x0 + 22*x1 <= 40, "taste_max")
m.addConstr(8*x0 - 5*x1 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bagged Salads: {x0.x}")
    print(f"Knishes: {int(x1.x)}")
else:
    print("No optimal solution found.")
