
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="bagged_salads", lb=0, ub=None)  # Continuous variable
    x2 = model.addVar(name="knishes", lb=0, integer=True)  # Integer variable

    # Define the objective function
    model.setObjective(5.3 * x1 + 8.08 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12 * x1 + 17 * x2 >= 29, name="iron_min")
    model.addConstr(12 * x1 + 17 * x2 <= 78, name="iron_max")
    model.addConstr(x1 + 22 * x2 >= 14, name="tastiness_min")
    model.addConstr(x1 + 22 * x2 <= 40, name="tastiness_max")
    model.addConstr(8 * x1 - 5 * x2 >= 0, name="bagged_salads_knishes")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bagged Salads: {x1.varValue}")
        print(f"Knishes: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
