
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, vtype=gp.GRB.INTEGER, name=["rubber_gloves", "cartons_of_milk", "candles", "dish_soap", "paper_plates"])


# Set objective function
m.setObjective(5.77*x[0]**2 + 7.78*x[1]*x[2] + 6.41*x[1]*x[3] + 8.17*x[1]*x[4] + 4.68*x[3] + 2.92*x[4], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x[1] + 3*x[2] >= 17)
m.addConstr(3*x[2] + 7*x[4] >= 32)
m.addConstr(10*x[0] + 7*x[4] >= 23)
m.addConstr(10*x[0]**2 + 4*x[1]**2 >= 36)
m.addConstr(10*x[0] + 2*x[3] >= 21)
m.addConstr(10*x[0] + 3*x[2] >= 40)

# ... (add all other constraints similarly)

m.addConstr(10 * x[0] <= 208)
m.addConstr(x[0] + 11 * x[1] + 8 * x[2] + x[3] + 4 * x[4] <= 204)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Obj: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

