
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="SOC_operators")
x1 = m.addVar(vtype=GRB.INTEGER, name="honeypots")
x2 = m.addVar(vtype=GRB.INTEGER, name="system_administrators")
x3 = m.addVar(vtype=GRB.INTEGER, name="deployed_decoys")
x4 = m.addVar(vtype=GRB.INTEGER, name="security_onions")
x5 = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")
x6 = m.addVar(vtype=GRB.INTEGER, name="network_administrators")


# Set objective function
m.setObjective(8.08*x0**2 + 6.07*x0*x1 + 6.32*x0*x2 + 9.36*x0*x4 + 5.44*x0*x5 + 7.68*x1**2 + 9.89*x1*x2 + 6.99*x1*x3 + 4.07*x1*x5 + 7.37*x1*x6 + 6.15*x2**2 + 9.27*x2*x3 + 9.55*x3**2 + 3.52*x3*x4 + 4.22*x0 + 2.05*x1 + 8.31*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5.67*x0 + 5.83*x2 >= 69)
m.addConstr(6.56*x1**2 + 5.83*x2**2 + 8.68*x5**2 >= 97)
m.addConstr(0.73*x0 + 2.44*x1 >= 47)
m.addConstr(0.73*x0 + 7.23*x2 >= 99)
m.addConstr(2.44*x1 + 8.92*x5 >= 117)
m.addConstr(0.74*x3**2 + 2.89*x6**2 >= 65)
m.addConstr(7.23*x2 + 8.92*x5 >= 121)
m.addConstr(0.73*x0 + 2.44*x1 + 9.78*x4 >= 121)
m.addConstr(2.96*x0 + 5.14*x5 >= 79)
m.addConstr(2.96*x0 + 5.58*x6 >= 56)
m.addConstr(6.56*x2**2 + 8.03*x4**2 >= 95)
m.addConstr(2.96*x0 + 8.03*x4 >= 45)
m.addConstr(9.19 * x1 + 2.9 * x3 >= 56)
m.addConstr(2.9 * x3 + 5.58 * x6 >= 40)
m.addConstr(8.03 * x4 + 5.58 * x6 >= 67)
m.addConstr(6.56 * x2**2 + 5.14 * x5**2 >= 62)
m.addConstr(2.9 * x3 + 8.03 * x4 >= 70)
m.addConstr(6.56 * x2 + 2.9 * x3 >= 42)
m.addConstr(5.14 * x5**2 + 5.58 * x6**2 >= 65)
m.addConstr(2.96 * x0**2 + 6.56 * x2**2 >= 45)


#Resource Constraints
for r in ['r0', 'r1', 'r2']:
    m.addConstr(quicksum(resource_data[r]['x' + str(i)] * vars()['x' + str(i)] for i in range(7)) <= resource_data[r]['upper_bound'])


# Additional Constraints
m.addConstr(4*x2**2 - 5*x3**2 + 2*x5**2 >= 0)
m.addConstr(5.67*x0 + 7.83*x4 <= 474)
m.addConstr(6.56*x1 + 5.83*x2 <= 503)
m.addConstr(5.67*x0 + 9.73*x3 <= 796)
m.addConstr(7.83*x4 + 2.42*x6 <= 871)
m.addConstr(7.83*x4**2 + 8.68*x5**2 <= 900)
m.addConstr(9.73*x3**2 + 2.42*x6**2 <= 394)
m.addConstr(5.67*x0 + 6.56*x1 <= 398)
m.addConstr(9.73*x3**2 + 7.83*x4**2 <= 774)
m.addConstr(9.73*x3 + 8.68*x5 <= 418)
m.addConstr(6.56*x1 + 9.73*x3 <= 391)
m.addConstr(0.74*x3**2 + 9.78*x4**2 <= 428)
m.addConstr(2.44*x1 + 0.74*x3 <= 367)
m.addConstr(7.23*x2 + 2.89*x6 <= 410)
m.addConstr(0.73*x0**2 + 0.74*x3**2 <= 204)
m.addConstr(9.78*x4 + 2.89*x6 <= 543)
m.addConstr(2.44*x1 + 8.92*x5 <= 263)
m.addConstr(9.78*x4**2 + 8.92*x5**2 <= 218)
m.addConstr(2.44*x1 + 2.89*x6 <= 854)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

