
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize Labor Cost")

    # Create variables
    paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")
    bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bill")
    dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")


    # Set objective function
    model.setObjective(9.56 * paul + 9.49 * bill + 9.3 * dale, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(17 * paul + 18 * bill + 12 * dale >= 77, "c0")
    model.addConstr(18 * bill + 12 * dale >= 35, "c1")
    model.addConstr(7 * paul + 8 * bill + 3 * dale >= 63, "c2")
    model.addConstr(7 * paul + 8 * bill >= 38, "c3")
    model.addConstr(paul - 4 * dale >= 0, "c4")
    model.addConstr(5 * bill - 8 * dale >= 0, "c5")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Paul: {paul.x}")
        print(f"Bill: {bill.x}")
        print(f"Dale: {dale.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
