
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='hours_worked_by_Paul', lb=0)
    x1 = model.addVar(name='hours_worked_by_Bill', lb=0)
    x2 = model.addVar(name='hours_worked_by_Dale', lb=0)

    # Define the objective function
    model.setObjective(9.56 * x0 + 9.49 * x1 + 9.3 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(17 * x0 <= 231)
    model.addConstr(7 * x0 <= 200)
    model.addConstr(18 * x1 <= 231)
    model.addConstr(8 * x1 <= 200)
    model.addConstr(12 * x2 <= 231)
    model.addConstr(3 * x2 <= 200)
    model.addConstr(18 * x1 + 12 * x2 >= 35)
    model.addConstr(17 * x0 + 12 * x2 >= 77)
    model.addConstr(17 * x0 + 18 * x1 + 12 * x2 >= 77)
    model.addConstr(7 * x0 + 8 * x1 >= 38)
    model.addConstr(7 * x0 + 8 * x1 + 3 * x2 >= 63)
    model.addConstr(x0 - 4 * x2 >= 0)
    model.addConstr(5 * x1 - 8 * x2 >= 0)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Paul: ', x0.varValue)
        print('Hours worked by Bill: ', x1.varValue)
        print('Hours worked by Dale: ', x2.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
