
import gurobipy as gp

# Create a new model
model = gp.Model("Maximize Snack Satisfaction")

# Create variables
oreos = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
cheeseburgers = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")

# Set objective function
model.setObjective(9.04 * oreos + 9.08 * cheeseburgers, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(9.91 * oreos + 6.97 * cheeseburgers >= 16, "tastiness_min")
model.addConstr(3.1 * oreos + 7.86 * cheeseburgers >= 25, "umami_min")
model.addConstr(8.48 * oreos + 7.22 * cheeseburgers >= 30, "cost_min")
model.addConstr(-3 * oreos + 2 * cheeseburgers >= 0, "ratio_constraint")
model.addConstr(9.91 * oreos + 6.97 * cheeseburgers <= 43, "tastiness_max")
model.addConstr(3.1 * oreos + 7.86 * cheeseburgers <= 95, "umami_max")
model.addConstr(8.48 * oreos + 7.22 * cheeseburgers <= 52, "cost_max")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Oreos: {oreos.x}")
    print(f"Cheeseburgers: {cheeseburgers.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

