
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Define the variables
x1 = model.addVar(lb=0, name="oreos")
x2 = model.addVar(lb=0, name="cheeseburgers")

# Set the objective function
model.setObjective(9.04*x1 + 9.08*x2, GRB.MAXIMIZE)

# Add the constraints
model.addConstr(9.91*x1 + 6.97*x2 >= 16, "tastiness_rating")
model.addConstr(3.1*x1 + 7.86*x2 >= 25, "umami_index")
model.addConstr(8.48*x1 + 7.22*x2 >= 30, "cost_lower_bound")
model.addConstr(8.48*x1 + 7.22*x2 <= 52, "cost_upper_bound")
model.addConstr(-3*x1 + 2*x2 >= 0, "linear_constraint")
model.addConstr(9.91*x1 + 6.97*x2 <= 43, "tastiness_rating_upper_bound")
model.addConstr(3.1*x1 + 7.86*x2 <= 95, "umami_index_upper_bound")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oreos: {x1.x}")
    print(f"Cheeseburgers: {x2.x}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found")
