
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="oreos", lb=0)  # oreos
x2 = m.addVar(name="cheeseburgers", lb=0)  # cheeseburgers

# Define the objective function
m.setObjective(9.04 * x1 + 9.08 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(9.91 * x1 + 6.97 * x2 >= 16, name="tastiness_rating_min")
m.addConstr(3.1 * x1 + 7.86 * x2 >= 25, name="umami_index_min")
m.addConstr(8.48 * x1 + 7.22 * x2 >= 30, name="dollar_cost_min")
m.addConstr(-3 * x1 + 2 * x2 >= 0, name="linear_combination")
m.addConstr(9.91 * x1 + 6.97 * x2 <= 43, name="tastiness_rating_max")
m.addConstr(3.1 * x1 + 7.86 * x2 <= 95, name="umami_index_max")
m.addConstr(8.48 * x1 + 7.22 * x2 <= 52, name="dollar_cost_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Oreos: ", x1.varValue)
    print("Cheeseburgers: ", x2.varValue)
else:
    print("The model is infeasible")
