
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin B5
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="x1") # milligrams of vitamin B12
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="x2") # milligrams of vitamin B9
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x3") # milligrams of zinc


# Set objective function
m.setObjective(2.62*x0**2 + 7.0*x0*x1 + 1.25*x0*x2 + 5.29*x1**2 + 1.87*x1*x2 + 9.68*x1*x3 + 9.91*x2*x3 + 9.91*x3**2 + 5.78*x0 + 5.09*x1 + 2.98*x2 + 9.3*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x0 + 3*x1 >= 15)
m.addConstr(6*x2 + 3*x3 >= 16)
m.addConstr(3*x1 + 3*x3 >= 15)
m.addConstr(10*x0**2 + 6*x2**2 >= 29)
m.addConstr(10*x0**2 + 3*x1**2 + 6*x2**2 >= 26)
m.addConstr(7*x0 + 13*x2 + 17*x3 >= 30)
m.addConstr(4*x1 + 7*x3 >= 11)
m.addConstr(14*x0**2 + 11*x2**2 >= 33)
m.addConstr(14*x0 + 7*x3 >= 23)
m.addConstr(14*x0 + 11*x2 + 7*x3 >= 26)
m.addConstr(10*x0 + 3*x3 <= 105)
m.addConstr(10*x0**2 + 6*x2**2 <= 92)
m.addConstr(10*x0**2 + 3*x1**2 + 3*x3**2 <= 104)
m.addConstr(10*x0 + 3*x1 + 6*x2 + 3*x3 <= 104)
m.addConstr(7*x0**2 + 17*x3**2 <= 67)
m.addConstr(13*x1**2 + 13*x2**2 <= 173)
m.addConstr(7*x0 + 13*x2 <= 179)
m.addConstr(13*x1 + 17*x3 <= 141)
m.addConstr(13*x2 + 17*x3 <= 96)
m.addConstr(7*x0 + 13*x1 + 17*x3 <= 128)
m.addConstr(7*x0**2 + 13*x1**2 + 13*x2**2 <= 51)
m.addConstr(7*x0 + 13*x1 + 13*x2 + 17*x3 <= 51)
m.addConstr(2*x1 + 17*x2 <= 119)
m.addConstr(10*x0 + 2*x1 <= 52)
m.addConstr(10*x0 + 2*x1 + 17*x2 + 15*x3 <= 52)
m.addConstr(4*x1 + 11*x2 <= 90)
m.addConstr(14*x0**2 + 4*x1**2 <= 71)
m.addConstr(11*x2**2 + 7*x3**2 <= 37)
m.addConstr(14*x0 + 4*x1 + 11*x2 + 7*x3 <= 37)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

