
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1", vtype=gurobi.GRB.CONTINUOUS)
x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2", vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3", vtype=gurobi.GRB.INTEGER)
x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x4", vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(2.62*x1**2 + 7.0*x1*x2 + 1.25*x1*x3 + 5.29*x2**2 + 1.87*x2*x3 + 9.68*x2*x4 + 9.91*x3*x4 + 9.91*x4**2 + 5.78*x1 + 5.09*x2 + 2.98*x3 + 9.3*x4, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x1 <= 128)
model.addConstr(7*x1 <= 201)
model.addConstr(10*x1 <= 202)
model.addConstr(14*x1 <= 138)
model.addConstr(3*x2 <= 128)
model.addConstr(13*x2 <= 201)
model.addConstr(2*x2 <= 202)
model.addConstr(4*x2 <= 138)
model.addConstr(6*x3 <= 128)
model.addConstr(13*x3 <= 201)
model.addConstr(17*x3 <= 202)
model.addConstr(11*x3 <= 138)
model.addConstr(3*x4 <= 128)
model.addConstr(17*x4 <= 201)
model.addConstr(15*x4 <= 202)
model.addConstr(7*x4 <= 138)
model.addConstr(10*x1 + 3*x2 >= 15)
model.addConstr(6*x3 + 3*x4 >= 16)
model.addConstr(3*x2 + 3*x4 >= 15)
model.addConstr(10*x1**2 + 6*x3**2 >= 29)
model.addConstr(10*x1**2 + 3*x2**2 + 6*x3**2 >= 26)
model.addConstr(7*x1 + 13*x3 + 17*x4 >= 30)
model.addConstr(4*x2 + 7*x4 >= 11)
model.addConstr(14*x1**2 + 11*x3**2 >= 33)
model.addConstr(14*x1 + 7*x4 >= 23)
model.addConstr(14*x1 + 11*x3 + 7*x4 >= 26)
model.addConstr(10*x1 + 3*x4 <= 105)
model.addConstr(10*x1**2 + 6*x3**2 <= 92)
model.addConstr(10*x1**2 + 3*x2**2 + x4**2 <= 104)
model.addConstr(10*x1 + 3*x2 + 6*x3 + 3*x4 <= 104)
model.addConstr(7*x1**2 + 17*x4**2 <= 67)
model.addConstr(13*x2**2 + 13*x3**2 <= 173)
model.addConstr(7*x1 + 13*x3 <= 179)
model.addConstr(13*x2 + 17*x4 <= 141)
model.addConstr(13*x3 + 17*x4 <= 96)
model.addConstr(7*x1 + 13*x2 + 17*x4 <= 128)
model.addConstr(7*x1**2 + 13*x2**2 + 13*x3**2 <= 51)
model.addConstr(7*x1 + 13*x2 + 13*x3 + 17*x4 <= 51)
model.addConstr(2*x2 + 17*x3 <= 119)
model.addConstr(10*x1 + 2*x2 <= 52)
model.addConstr(10*x1 + 2*x2 + 17*x3 + 15*x4 <= 52)
model.addConstr(4*x2 + 11*x3 <= 90)
model.addConstr(14*x1**2 + 4*x2**2 <= 71)
model.addConstr(11*x3**2 + 7*x4**2 <= 37)
model.addConstr(14*x1 + 4*x2 + 11*x3 + 7*x4 <= 37)

# Optimize the model
model.optimize()

# Print the solution
print("Objective: ", model.objVal)
print("x1: ", x1.varValue)
print("x2: ", x2.varValue)
print("x3: ", x3.varValue)
print("x4: ", x4.varValue)

