
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="potatoes")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cornichons")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")


    # Set objective function
    m.setObjective(3*x0 + 2*x1 + 2*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(16*x0 <= 189, "c0")
    m.addConstr(25*x0 <= 193, "c1")
    m.addConstr(18*x0 <= 301, "c2")
    m.addConstr(24*x1 <= 189, "c3")
    m.addConstr(22*x1 <= 193, "c4")
    m.addConstr(18*x1 <= 301, "c5")
    m.addConstr(9*x2 <= 189, "c6")
    m.addConstr(2*x2 <= 193, "c7")
    m.addConstr(23*x2 <= 301, "c8")
    m.addConstr(24*x1 + 9*x2 >= 51, "c9")
    m.addConstr(25*x0 + 22*x1 + 2*x2 >= 51, "c10")
    m.addConstr(18*x0 + 18*x1 + 23*x2 >= 90, "c11")
    m.addConstr(16*x0 + 9*x2 <= 66, "c12")
    m.addConstr(16*x0 + 24*x1 <= 91, "c13")
    m.addConstr(16*x0 + 24*x1 + 9*x2 <= 91, "c14")
    m.addConstr(25*x0 + 2*x2 <= 168, "c15")
    m.addConstr(25*x0 + 22*x1 + 2*x2 <= 168, "c16")
    m.addConstr(18*x1 + 23*x2 <= 175, "c17")
    m.addConstr(18*x0 + 18*x1 + 23*x2 <= 175, "c18")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
