
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")
    x1 = model.addVar(lb=0, vtype=GRB.INTEGER, name="hours_worked_by_George")


    # Set objective function
    model.setObjective(1 * x0 + 3 * x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.82 * x0 + 0.01 * x1 >= 7, "organization_score_min")
    model.addConstr(1.78 * x0 + 1.34 * x1 >= 6, "productivity_rating_min")
    model.addConstr(7 * x0 - 2 * x1 >= 0, "constraint_3")
    model.addConstr(0.82 * x0 + 0.01 * x1 <= 19, "organization_score_max")
    model.addConstr(1.78 * x0 + 1.34 * x1 <= 22, "productivity_rating_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", model.objVal)
        print("hours worked by Laura:", x0.x)
        print("hours worked by George:", x1.x)

except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model optimized successfully.")

