
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")

# Objective function: Maximize hours worked by Laura plus 3 times hours worked by George
m.setObjective(x1 + 3*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(0.82*x1 + 0.01*x2 >= 7, "Total organization score constraint")
m.addConstr(1.78*x1 + 1.34*x2 >= 6, "Total productivity rating minimum constraint")
m.addConstr(7*x1 - 2*x2 >= 0, "Linear inequality constraint")
m.addConstr(0.82*x1 + 0.01*x2 <= 19, "Maximum total organization score constraint")
m.addConstr(1.78*x1 + 1.34*x2 <= 22, "Maximum productivity rating constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Laura: {x1.x}")
    print(f"Hours worked by George: {x2.x}")
else:
    print("No optimal solution found")
