
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Laura", lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name="hours_worked_by_George", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(1 * x1 + 3 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(0.82 * x1 + 0.01 * x2 >= 7)
    model.addConstr(1.78 * x1 + 1.34 * x2 >= 6)
    model.addConstr(7 * x1 - 2 * x2 >= 0)
    model.addConstr(0.82 * x1 + 0.01 * x2 <= 19)
    model.addConstr(1.78 * x1 + 1.34 * x2 <= 22)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Laura: {x1.varValue}")
        print(f"Hours worked by George: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
