
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_model")

# Create variables
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
paul = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="paul")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")


# Set objective function
m.setObjective(6*hank**2 + 3*hank*mary + 6*mary*ringo + 6*paul*ringo + 8*ringo**2 + hank + 8*mary, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*hank**2 + 12*paul**2 >= 26)
m.addConstr(2*mary + 12*ringo >= 12)
m.addConstr(12*paul + 12*ringo >= 20)
m.addConstr(2*mary + 12*paul >= 26)
m.addConstr(4*hank + 12*ringo >= 11)
m.addConstr(4*hank**2 + 2*mary**2 + 12*ringo**2 >= 20)
m.addConstr(2*mary**2 + 12*paul**2 + 12*ringo**2 >= 20)
m.addConstr(4*hank + 12*paul + 12*ringo >= 20)
m.addConstr(4*hank + 2*mary + 12*paul >= 20)
m.addConstr(4*hank**2 + 2*mary**2 + 12*ringo**2 >= 17)
m.addConstr(2*mary**2 + 12*paul**2 + 12*ringo**2 >= 17)
m.addConstr(4*hank + 12*paul + 12*ringo >= 17)
m.addConstr(4*hank + 2*mary + 12*paul >= 17)
m.addConstr(4*hank**2 + 2*mary**2 + 12*ringo**2 >= 15)
m.addConstr(2*mary + 12*paul + 12*ringo >= 15)
m.addConstr(4*hank + 12*paul + 12*ringo >= 15)
m.addConstr(4*hank + 2*mary + 12*paul >= 15)
m.addConstr(4*hank**2 + 2*mary**2 + 12*ringo**2 >= 15)
m.addConstr(2*mary + 12*paul + 12*ringo >= 15)
m.addConstr(4*hank + 12*paul + 12*ringo >= 15)
m.addConstr(4*hank**2 + 2*mary**2 + 12*paul**2 >= 15)
m.addConstr(13*hank**2 + 14*paul**2 >= 13)
m.addConstr(13*hank + 10*mary + 6*ringo >= 20)
m.addConstr(hank**2 + mary**2 >= 12)
m.addConstr(14*paul**2 + 11*ringo**2 >= 33)
m.addConstr(hank + 11*ringo >= 19)
m.addConstr(hank + 14*paul >= 11)
m.addConstr(mary + 11*ringo >= 16)
m.addConstr(2*mary + 12*ringo <= 89)
m.addConstr(4*hank + 12*paul <= 88)
m.addConstr(2*mary + 12*paul <= 36)
m.addConstr(4*hank + 2*mary + 12*paul + 12*ringo <= 36)
m.addConstr(13*hank + 6*ringo <= 81)
m.addConstr(10*mary**2 + 14*paul**2 <= 61)
m.addConstr(13*hank + 14*paul + 6*ringo <= 51)
m.addConstr(13*hank + 10*mary + 14*paul <= 109)
m.addConstr(13*hank**2 + 10*mary**2 + 6*ringo**2 <= 78)
m.addConstr(13*hank + 10*mary + 14*paul + 6*ringo <= 78)
m.addConstr(mary + 14*paul <= 35)
m.addConstr(hank + 11*ringo <= 131)
m.addConstr(mary + 11*ringo <= 98)
m.addConstr(hank + mary <= 127)
m.addConstr(hank + mary + 14*paul <= 129)
m.addConstr(hank + mary + 14*paul + 11*ringo <= 129)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

