
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Hank
x1 = m.addVar(name="x1", lb=0)  # hours worked by Mary
x2 = m.addVar(name="x2", lb=0, integrality=1)  # hours worked by Paul
x3 = m.addVar(name="x3", lb=0)  # hours worked by Ringo

# Objective function
m.setObjective(6*x0**2 + 3*x0*x1 + 6*x1*x3 + 6*x2*x3 + 8*x3**2 + x0 + 8*x1, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(4*x0 <= 113)
m.addConstr(13*x0 <= 134)
m.addConstr(x0 <= 133)
m.addConstr(2*x1 <= 113)
m.addConstr(10*x1 <= 134)
m.addConstr(x1 <= 133)
m.addConstr(12*x2 <= 113)
m.addConstr(14*x2 <= 134)
m.addConstr(14*x2 <= 133)
m.addConstr(12*x3 <= 113)
m.addConstr(6*x3 <= 134)
m.addConstr(11*x3 <= 133)
m.addConstr(4*x0**2 + 12*x2**2 >= 26)
m.addConstr(2*x1 + 12*x3 >= 12)
m.addConstr(12*x2 + 12*x3 >= 20)
m.addConstr(2*x1 + 12*x2 >= 26)
m.addConstr(4*x0 + 12*x3 >= 11)
m.addConstr(4*x0**2 + 4*x1**2 + 12*x3**2 >= 20)
m.addConstr(4*x1**2 + 12*x2**2 + 12*x3**2 >= 20)
m.addConstr(4*x0 + 12*x2 + 12*x3 >= 20)
m.addConstr(4*x0 + 2*x1 + 12*x2 >= 20)
m.addConstr(4*x0**2 + 4*x1**2 + 12*x3**2 >= 17)
m.addConstr(4*x1**2 + 12*x2**2 + 12*x3**2 >= 17)
m.addConstr(4*x0 + 12*x2 + 12*x3 >= 17)
m.addConstr(4*x0 + 2*x1 + 12*x2 >= 17)
m.addConstr(4*x0**2 + 4*x1**2 + 12*x3**2 >= 15)
m.addConstr(2*x1 + 12*x2 + 12*x3 >= 15)
m.addConstr(4*x0 + 12*x2 + 12*x3 >= 15)
m.addConstr(4*x0 + 2*x1 + 12*x2 >= 15)
m.addConstr(4*x0**2 + 4*x1**2 + 4*x2**2 >= 15)
m.addConstr(13*x0**2 + 14*x2**2 >= 13)
m.addConstr(13*x0 + 10*x1 + 6*x3 >= 20)
m.addConstr(x0**2 + x1**2 >= 12)
m.addConstr(14*x2**2 + 11*x3**2 >= 33)
m.addConstr(x0 + 6*x3 >= 19)
m.addConstr(x0 + x2 >= 11)
m.addConstr(x1 + 6*x3 >= 16)
m.addConstr(2*x1 + 12*x3 <= 89)
m.addConstr(4*x0 + 12*x2 <= 88)
m.addConstr(2*x1 + 12*x2 <= 36)
m.addConstr(4*x0 + 2*x1 + 12*x2 + 12*x3 <= 36)
m.addConstr(13*x0 + 6*x3 <= 81)
m.addConstr(10*x1**2 + 14*x2**2 <= 61)
m.addConstr(13*x0 + 14*x2 + 6*x3 <= 51)
m.addConstr(13*x0 + 10*x1 + 14*x2 <= 109)
m.addConstr(13*x0**2 + 10*x1**2 + 6*x3**2 <= 78)
m.addConstr(13*x0 + 10*x1 + 14*x2 + 6*x3 <= 78)
m.addConstr(x1 + 14*x2 <= 35)
m.addConstr(x0 + 6*x3 <= 131)
m.addConstr(x1 + 6*x3 <= 98)
m.addConstr(x0 + x1 <= 127)
m.addConstr(x0 + x1 + 14*x2 <= 129)
m.addConstr(x0 + x1 + 14*x2 + 6*x3 <= 129)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Hank: ", x0.varValue)
    print("Hours worked by Mary: ", x1.varValue)
    print("Hours worked by Paul: ", x2.varValue)
    print("Hours worked by Ringo: ", x3.varValue)
else:
    print("The model is infeasible")
