
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("minimize_work_hours")

    # Create variables
    dale_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dale_hours")
    jean_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="jean_hours")
    bill_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bill_hours")


    # Set objective function
    model.setObjective(7 * dale_hours + 8 * jean_hours + 3 * bill_hours, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * dale_hours + 9 * bill_hours >= 16, "c1")
    model.addConstr(9 * dale_hours + 8 * jean_hours >= 12, "c2")
    model.addConstr(9 * dale_hours + 8 * jean_hours + 9 * bill_hours >= 12, "c3")
    model.addConstr(5 * dale_hours + 6 * bill_hours >= 27, "c4")
    model.addConstr(6 * jean_hours + 6 * bill_hours >= 12, "c5")
    model.addConstr(5 * dale_hours + 6 * jean_hours + 6 * bill_hours >= 12, "c6")
    model.addConstr(10 * dale_hours - 3 * jean_hours >= 0, "c7")
    model.addConstr(9 * dale_hours + 8 * jean_hours + 9 * bill_hours <= 57, "c8")
    model.addConstr(5 * dale_hours + 6 * jean_hours + 6 * bill_hours <= 43, "c9")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Dale Hours: %g' % dale_hours.x)
        print('Jean Hours: %g' % jean_hours.x)
        print('Bill Hours: %g' % bill_hours.x)
    elif model.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
