
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0, ub=68/9, vtype=gurobi.GRB.CONTINUOUS)  # hours worked by Dale
    x1 = model.addVar(name="x1", lb=0, ub=102/6, vtype=gurobi.GRB.INTEGER)  # hours worked by Jean
    x2 = model.addVar(name="x2", lb=0, ub=68/9, vtype=gurobi.GRB.CONTINUOUS)  # hours worked by Bill

    # Objective function
    model.setObjective(7*x0 + 8*x1 + 3*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9*x0 <= 68)
    model.addConstr(5*x0 <= 102)
    model.addConstr(8*x1 <= 68)
    model.addConstr(6*x1 <= 102)
    model.addConstr(9*x2 <= 68)
    model.addConstr(6*x2 <= 102)
    model.addConstr(9*x0 + 9*x2 >= 16)
    model.addConstr(9*x0 + 8*x1 >= 12)
    model.addConstr(9*x0 + 8*x1 + 9*x2 >= 12)
    model.addConstr(5*x0 + 6*x2 >= 27)
    model.addConstr(6*x1 + 6*x2 >= 12)
    model.addConstr(5*x0 + 6*x1 + 6*x2 >= 12)
    model.addConstr(10*x0 - 3*x1 >= 0)
    model.addConstr(9*x0 + 8*x1 + 9*x2 <= 57)
    model.addConstr(5*x0 + 6*x1 + 6*x2 <= 43)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Dale: ", x0.varValue)
        print("Hours worked by Jean: ", x1.varValue)
        print("Hours worked by Bill: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
