
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    candles = m.addVar(vtype=gp.GRB.INTEGER, name="candles")
    paper_towel_rolls = m.addVar(vtype=gp.GRB.INTEGER, name="paper_towel_rolls")
    packs_of_paper_plates = m.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper_plates")
    cartons_of_milk = m.addVar(vtype=gp.GRB.INTEGER, name="cartons_of_milk")

    # Set objective function
    m.setObjective(1*candles + 4*paper_towel_rolls + 3*packs_of_paper_plates + 1*cartons_of_milk, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7.91*candles + 2.09*paper_towel_rolls >= 6)
    m.addConstr(2.09*paper_towel_rolls + 0.23*packs_of_paper_plates >= 10)
    m.addConstr(0.23*packs_of_paper_plates + 8.79*cartons_of_milk >= 11)
    m.addConstr(2.09*paper_towel_rolls + 0.23*packs_of_paper_plates + 8.79*cartons_of_milk >= 10)
    m.addConstr(7.91*candles + 2.09*paper_towel_rolls + 0.23*packs_of_paper_plates + 8.79*cartons_of_milk >= 10)
    m.addConstr(2.58*candles + 1.15*cartons_of_milk >= 13)
    m.addConstr(1.98*paper_towel_rolls + 1.15*cartons_of_milk >= 11)
    m.addConstr(1.98*paper_towel_rolls + 5.51*packs_of_paper_plates >= 4)
    m.addConstr(2.58*candles + 1.98*paper_towel_rolls + 5.51*packs_of_paper_plates + 1.15*cartons_of_milk >= 4)
    m.addConstr(3*candles - 3*packs_of_paper_plates >= 0)
    m.addConstr(0.23*packs_of_paper_plates + 8.79*cartons_of_milk <= 42)
    m.addConstr(7.91*candles + 2.09*paper_towel_rolls <= 14)
    m.addConstr(7.91*candles + 8.79*cartons_of_milk <= 42)
    m.addConstr(5.51*packs_of_paper_plates + 1.15*cartons_of_milk <= 36)
    m.addConstr(2.58*candles + 1.98*paper_towel_rolls <= 21)
    m.addConstr(2.58*candles + 5.51*packs_of_paper_plates <= 17)
    m.addConstr(1.98*paper_towel_rolls + 5.51*packs_of_paper_plates <= 29)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Other optimization status')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
