
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    candles = model.addVar(name="candles", vtype=gurobi.GRB.INTEGER)
    paper_towel_rolls = model.addVar(name="paper_towel_rolls", vtype=gurobi.GRB.INTEGER)
    packs_of_paper_plates = model.addVar(name="packs_of_paper_plates", vtype=gurobi.GRB.INTEGER)
    cartons_of_milk = model.addVar(name="cartons_of_milk", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(candles + 4 * paper_towel_rolls + 3 * packs_of_paper_plates + cartons_of_milk, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7.91 * candles + 2.09 * paper_towel_rolls >= 6)
    model.addConstr(2.09 * paper_towel_rolls + 0.23 * packs_of_paper_plates >= 10)
    model.addConstr(0.23 * packs_of_paper_plates + 8.79 * cartons_of_milk >= 11)
    model.addConstr(2.09 * paper_towel_rolls + 0.23 * packs_of_paper_plates + 8.79 * cartons_of_milk >= 10)
    model.addConstr(7.91 * candles + 2.09 * paper_towel_rolls + 0.23 * packs_of_paper_plates + 8.79 * cartons_of_milk >= 10)
    model.addConstr(2.58 * candles + 1.15 * cartons_of_milk >= 13)
    model.addConstr(1.98 * paper_towel_rolls + 1.15 * cartons_of_milk >= 11)
    model.addConstr(1.98 * paper_towel_rolls + 5.51 * packs_of_paper_plates >= 4)
    model.addConstr(2.58 * candles + 1.98 * paper_towel_rolls + 5.51 * packs_of_paper_plates + 1.15 * cartons_of_milk >= 4)
    model.addConstr(3 * candles - 3 * packs_of_paper_plates >= 0)
    model.addConstr(0.23 * packs_of_paper_plates + 8.79 * cartons_of_milk <= 42)
    model.addConstr(7.91 * candles + 2.09 * paper_towel_rolls <= 14)
    model.addConstr(7.91 * candles + 8.79 * cartons_of_milk <= 42)
    model.addConstr(5.51 * packs_of_paper_plates + 1.15 * cartons_of_milk <= 36)
    model.addConstr(2.58 * candles + 1.98 * paper_towel_rolls <= 21)
    model.addConstr(2.58 * candles + 5.51 * packs_of_paper_plates <= 17)
    model.addConstr(1.98 * paper_towel_rolls + 5.51 * packs_of_paper_plates <= 29)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Candles: ", candles.varValue)
        print("Paper Towel Rolls: ", paper_towel_rolls.varValue)
        print("Packs of Paper Plates: ", packs_of_paper_plates.varValue)
        print("Cartons of Milk: ", cartons_of_milk.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
