
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_allocation")

    # Create variables
    intrusion_analysts = model.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")
    automatic_alerts = model.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")


    # Set objective function
    model.setObjective(9.56 * intrusion_analysts + 5.67 * automatic_alerts, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.03 * intrusion_analysts + 0.37 * automatic_alerts >= 100, "data_accessibility_impact_min")
    model.addConstr(0.99 * intrusion_analysts + 1.39 * automatic_alerts >= 23, "computational_load_min")
    model.addConstr(-6 * intrusion_analysts + 2 * automatic_alerts >= 0, "constraint3")
    model.addConstr(0.03 * intrusion_analysts + 0.37 * automatic_alerts <= 187, "data_accessibility_impact_max")
    model.addConstr(0.99 * intrusion_analysts + 1.39 * automatic_alerts <= 80, "computational_load_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Intrusion Analysts: {intrusion_analysts.x}")
        print(f"Automatic Alerts: {automatic_alerts.x}")
        print(f"Objective Value: {model.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
