
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")
x2 = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")

# Set the objective function
m.setObjective(9.56*x1 + 5.67*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.03*x1 + 0.37*x2 >= 100, "data_accessibility_impact_min")
m.addConstr(0.99*x1 + 1.39*x2 >= 23, "computational_load_min")
m.addConstr(-6*x1 + 2*x2 >= 0, "intrusion_alerts_constraint")
m.addConstr(0.03*x1 + 0.37*x2 <= 187, "data_accessibility_impact_max")
m.addConstr(0.99*x1 + 1.39*x2 <= 80, "computational_load_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Intrusion Analysts: {x1.x}")
    print(f"Automatic Alerts: {x2.x}")
else:
    print("No optimal solution found")
