
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="intrusion_analysts", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="automatic_alerts", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(9.56 * x1 + 5.67 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(0.03 * x1 + 0.37 * x2 >= 100)
    model.addConstr(0.99 * x1 + 1.39 * x2 >= 23)
    model.addConstr(0.03 * x1 + 0.37 * x2 <= 187)
    model.addConstr(0.99 * x1 + 1.39 * x2 <= 80)
    model.addConstr(-6 * x1 + 2 * x2 >= 0)

    # Set bounds for variables (non-negativity)
    x1.lb = 0
    x2.lb = 0

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Intrusion Analysts: {x1.varValue}")
        print(f"Automatic Alerts: {x2.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
