
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")


# Set objective function
m.setObjective(8.54*x0**2 + 9.47*x0*x1 + 5.05*x0*x2 + 5.04*x1**2 + 6.27*x1*x2 + 1.01*x1*x3 + 9.4*x2*x3 + 7.08*x3**2 + 2.74*x1 + 2.72*x2 + 1.13*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9*x0 + 7*x1 + 5*x2 + 2*x3 <= 240)
m.addConstr(9*x0 + 13*x1 + 9*x2 + 14*x3 <= 237)
m.addConstr(5*x2**2 + 2*x3**2 >= 54)
m.addConstr(9*x0**2 + 2*x3**2 >= 47)
m.addConstr(7*x1 + 2*x3 >= 57)
m.addConstr(9*x0**2 + 5*x2**2 + 2*x3**2 >= 45)
m.addConstr(7*x1**2 + 5*x2**2 + 2*x3**2 >= 45)
m.addConstr(9*x0 + 7*x1 + 5*x2 >= 45)
m.addConstr(9*x0 + 5*x2 + 2*x3 >= 53)
m.addConstr(7*x1 + 5*x2 + 2*x3 >= 53)
m.addConstr(9*x0 + 7*x1 + 5*x2 >= 53)
m.addConstr(9*x0 + 5*x2 + 2*x3 >= 35)
m.addConstr(7*x1**2 + 5*x2**2 + 2*x3**2 >= 35)
m.addConstr(9*x0 + 7*x1 + 5*x2 >= 35)
m.addConstr(9*x0 + 7*x1 + 5*x2 + 2*x3 >= 35)
m.addConstr(13*x1**2 + 9*x2**2 >= 26)
m.addConstr(13*x1 + 14*x3 >= 47)
m.addConstr(9*x2 + 14*x3 >= 51)
m.addConstr(9*x0**2 + 14*x3**2 >= 19)
m.addConstr(9*x0 + 13*x1 + 9*x2 + 14*x3 >= 19)
m.addConstr(2*x0 - 10*x3 >= 0)
m.addConstr(-9*x0 + 6*x1 >= 0)
m.addConstr(7*x1 + 5*x2 <= 106)
m.addConstr(9*x0 + 5*x2 <= 201)
m.addConstr(9*x0 + 7*x1 <= 122)
m.addConstr(9*x0 + 2*x3 <= 193)
m.addConstr(9*x0**2 + 5*x2**2 + 2*x3**2 <= 156)
m.addConstr(9*x0 + 7*x1 + 5*x2 <= 171)
m.addConstr(13*x1**2 + 14*x3**2 <= 221)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

