
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='x0')
x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='x1')
x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='x2')
x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='x3')

# Objective function
model.setObjective(8.54*x0**2 + 9.47*x0*x1 + 5.05*x0*x2 + 5.04*x1**2 + 6.27*x1*x2 + 1.01*x1*x3 + 9.4*x2*x3 + 7.08*x3**2 + 2.74*x1 + 2.72*x2 + 1.13*x3, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(9*x0 <= 240)
model.addConstr(9*x0 <= 237)
model.addConstr(7*x1 <= 240)
model.addConstr(13*x1 <= 237)
model.addConstr(5*x2 <= 240)
model.addConstr(9*x2 <= 237)
model.addConstr(2*x3 <= 240)
model.addConstr(14*x3 <= 237)
model.addConstr(5*x2**2 + 2*x3**2 >= 54)
model.addConstr(9*x0**2 + 2*x3**2 >= 47)
model.addConstr(7*x1 + 2*x3 >= 57)
model.addConstr(9*x0**2 + 5*x2**2 + 2*x3**2 >= 45)
model.addConstr(7*x1**2 + 5*x2**2 + 2*x3**2 >= 45)
model.addConstr(9*x0 + 7*x1 + 5*x2 >= 45)
model.addConstr(9*x0 + 5*x2 + 2*x3 >= 53)
model.addConstr(7*x1 + 5*x2 + 2*x3 >= 53)
model.addConstr(9*x0 + 7*x1 + 5*x2 >= 53)
model.addConstr(9*x0 + 5*x2 + 2*x3 >= 35)
model.addConstr(7*x1**2 + 5*x2**2 + 2*x3**2 >= 35)
model.addConstr(9*x0 + 7*x1 + 5*x2 >= 35)
model.addConstr(9*x0 + 7*x1 + 5*x2 + 2*x3 >= 35)
model.addConstr(13*x1**2 + 9*x2**2 >= 26)
model.addConstr(13*x1 + 14*x3 >= 47)
model.addConstr(9*x2 + 14*x3 >= 51)
model.addConstr(9*x0**2 + 14*x3**2 >= 19)
model.addConstr(9*x0 + 7*x1 + 5*x2 + 14*x3 >= 19)
model.addConstr(2*x0 - 10*x3 >= 0)
model.addConstr(-9*x0 + 6*x1 >= 0)
model.addConstr(7*x1 + 5*x2 <= 106)
model.addConstr(9*x0 + 5*x2 <= 201)
model.addConstr(9*x0 + 7*x1 <= 122)
model.addConstr(9*x0 + 2*x3 <= 193)
model.addConstr(9*x0**2 + 5*x2**2 + 2*x3**2 <= 156)
model.addConstr(9*x0 + 7*x1 + 5*x2 <= 171)
model.addConstr(13*x1**2 + 2*x3**2 <= 221)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
else:
    print('No solution found')
