
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_a = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
vitamin_b9 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
vitamin_k = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
vitamin_c = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
vitamin_d = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_d")


# Set objective function
m.setObjective(5*vitamin_a**2 + vitamin_a*vitamin_b9 + 4*vitamin_a*vitamin_d + 2*vitamin_b9*vitamin_c + 5*vitamin_b9*vitamin_d + 5*vitamin_k*vitamin_d + 4*vitamin_b9, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6*vitamin_a + 3*vitamin_k >= 19)
m.addConstr(6*vitamin_a + 6*vitamin_b9 + 3*vitamin_k + vitamin_c + 10*vitamin_d >= 19)
# ... (add all other constraints from the JSON "constraints" field)
m.addConstr(6 * vitamin_a + 6 * vitamin_b9 + 3 * vitamin_k + vitamin_c + 10 * vitamin_d <= 98)
m.addConstr(9 * vitamin_a + 2 * vitamin_b9 + 9 * vitamin_k + 2 * vitamin_c + 5 * vitamin_d <= 173)
m.addConstr(4 * vitamin_a + 11 * vitamin_b9 + 6 * vitamin_k + 6 * vitamin_c + vitamin_d <= 82)


# Add non-negativity constraints
m.addConstr(vitamin_a >= 0)
m.addConstr(vitamin_b9 >= 0)
m.addConstr(vitamin_k >= 0)
m.addConstr(vitamin_c >= 0)
m.addConstr(vitamin_d >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_a:', vitamin_a.x)
    print('vitamin_b9:', vitamin_b9.x)
    print('vitamin_k:', vitamin_k.x)
    print('vitamin_c:', vitamin_c.x)
    print('vitamin_d:', vitamin_d.x)

elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

