
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
fruit_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
bowls_of_cereal = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bowls_of_cereal")
bowls_of_pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_pasta")

# Set objective function
m.setObjective(1 * fruit_salads + 7 * bowls_of_cereal + 2 * bowls_of_pasta, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * fruit_salads + 1 * bowls_of_cereal + 6 * bowls_of_pasta >= 24, "sourness_min")
m.addConstr(6 * bowls_of_cereal + 1 * bowls_of_pasta >= 19, "umami_cereal_pasta_min")
m.addConstr(1 * bowls_of_cereal + 6 * bowls_of_pasta <= 96, "sourness_cereal_pasta_max")
m.addConstr(7 * fruit_salads + 1 * bowls_of_cereal + 6 * bowls_of_pasta <= 96, "sourness_max")
m.addConstr(1 * fruit_salads + 5 * bowls_of_pasta <= 75, "cost_fruit_pasta_max")
m.addConstr(8 * bowls_of_cereal + 5 * bowls_of_pasta <= 112, "cost_cereal_pasta_max")
m.addConstr(1 * fruit_salads + 8 * bowls_of_cereal + 5 * bowls_of_pasta <= 112, "cost_max")
m.addConstr(2 * fruit_salads + 6 * bowls_of_cereal <= 77, "umami_fruit_cereal_max")
m.addConstr(2 * fruit_salads + 6 * bowls_of_cereal + 1 * bowls_of_pasta <= 77, "umami_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('fruit_salads:', fruit_salads.x)
    print('bowls_of_cereal:', bowls_of_cereal.x)
    print('bowls_of_pasta:', bowls_of_pasta.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

