
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="fruit_salads", lb=0, ub=None)  # Can be fractional
x1 = model.addVar(name="bowls_of_cereal", lb=0, ub=None, integrality=gurobi.GRB.INTEGER)  # Must be integer
x2 = model.addVar(name="bowls_of_pasta", lb=0, ub=None)  # Can be fractional

# Objective function
model.setObjective(1*x0 + 7*x1 + 2*x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(7*x0 + x1 + 6*x2 >= 24, name="sourness_index_total")
model.addConstr(6*x1 + x2 >= 19, name="umami_index_cereal_pasta")
model.addConstr(x1 + 6*x2 <= 96, name="sourness_index_cereal_pasta")
model.addConstr(7*x0 + x1 + 6*x2 <= 96, name="sourness_index_total_max")
model.addConstr(x0 + 5*x2 <= 75, name="cost_fruit_salads_pasta")
model.addConstr(8*x1 + 5*x2 <= 112, name="cost_cereal_pasta")
model.addConstr(x0 + 8*x1 + 5*x2 <= 112, name="cost_total")
model.addConstr(2*x0 + 6*x1 <= 77, name="umami_index_fruit_cereal")
model.addConstr(2*x0 + 6*x1 + x2 <= 77, name="umami_index_total")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Fruit Salads: ", x0.varValue)
    print("Bowls of Cereal: ", x1.varValue)
    print("Bowls of Pasta: ", x2.varValue)
else:
    print("The model is infeasible")
