
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="grams_of_fiber")
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B6")

    # Set objective function
    m.setObjective(3.28 * x0 + 1.26 * x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(19 * x0 + 9 * x1 >= 34, "digestive_support_min")
    m.addConstr(1 * x0 + 1 * x1 >= 59, "immune_support_min")
    m.addConstr(9 * x0 - 1 * x1 >= 0, "constraint_3")
    m.addConstr(19 * x0 + 9 * x1 <= 118, "digestive_support_max")
    m.addConstr(1 * x0 + 1 * x1 <= 123, "immune_support_max")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"grams of fiber: {x0.x}")
        print(f"milligrams of vitamin B6: {x1.x}")
        print(f"Objective Value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
