
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="grams_of_fiber")  # Whole number constraint for grams of fiber
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B6")  # Continuous variable for milligrams of vitamin B6

# Objective function: Minimize 3.28*x1 + 1.26*x2
m.setObjective(3.28*x1 + 1.26*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(19*x1 + 9*x2 >= 34, name="digestive_support_index_min")
m.addConstr(x1 + x2 >= 59, name="immune_support_index_min")
m.addConstr(9*x1 - x2 >= 0, name="additional_constraint")
m.addConstr(19*x1 + 9*x2 <= 118, name="digestive_support_index_max")
m.addConstr(x1 + x2 <= 123, name="immune_support_index_max")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of Fiber: {x1.x}")
    print(f"Milligrams of Vitamin B6: {x2.x}")
else:
    print("No optimal solution found")
