
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="grams_of_fiber", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="milligrams_of_vitamin_B6")

    # Define the objective function
    model.setObjective(3.28 * x1 + 1.26 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(19 * x1 + 9 * x2 >= 34, name="digestive_support_index_min")
    model.addConstr(x1 + x2 >= 59, name="immune_support_index_min")
    model.addConstr(9 * x1 - x2 >= 0, name="fiber_vitamin_B6_balance")
    model.addConstr(19 * x1 + 9 * x2 <= 118, name="digestive_support_index_max")
    model.addConstr(x1 + x2 <= 123, name="immune_support_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of fiber: {x1.varValue}")
        print(f"Milligrams of vitamin B6: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
